﻿#include "gameFunctions/copyObject.as"
#include "gameFunctions/evalPath.as"
#include "gameFunctions/getPathValue.as"
if(RAM_F==undefined)		RAM_F = {};
// __________________________________________________________
// copySprite
RAM_F.copySprite = function()
{
	var spriteName = arguments[0];		// when called from a script, spriteName's [] vars will get resolved before this function is called
	var storePath = arguments[1];
	// var spritePath = evalPath( spriteName, "SPRITES" );		// sprite names default to being relative to SPRITES, unless otherwise specified
	var spritePath = evalPath( spriteName, "SPRITES" );		// sprite names default to being relative to SPRITES, unless otherwise specified
	var sprite_mc = getPathValue( spritePath );						// get a direct reference to this sprite's movieClip
	// get the specified sprite's settings
	var spriteData = sprite_mc.image.getParams();
	if(spriteData)
	{// if:  there's sprite data to copy
		// copy the sprite's settings to the target object  (replacing that object's contents)
		// // identify the destination object's container
		if(storePath){
			var endAt = storePath.lastIndexOf(".");
			var containerPath = (endAt==-1) ? "RAM" : storePath.substr(0,endAt);
			var newObjName = storePath.substr(endAt+1);
			var storeContainer = evalPath( containerPath, "RAM" );
		}
		// // create the destination object
		var destObj = {};
		if(storeContainer)		storeContainer[newObjName] = destObj;
		// // copy the data to the target object
		copyObject( spriteData, destObj );
		// also return the results directly
		return destObj;
	}// if:  there's sprite data to copy
}// copySprite()


// __________________________________________________________
// copyObject
RAM_F.copyObject = function()
{
	var src_path = arguments[0];
	var dest_path = arguments[1];
	var src = evalPath(src_path, "RAM");
	var dest = evalPath(dest_path, "RAM") || {};
	if(src && dest)
		copyObject( src, dest );
	return dest;
}// copyObject()


// __________________________________________________________
// replaceText  (this can replace "removeText" by simply skipping the 3rd parameter)
RAM_F.replaceText = function(){
	var replaceThis = arguments[0];
	var fromThis = arguments[1];
	var withThis = arguments[2] || "";
	var output = fromThis.split( replaceThis ).join( withThis );
	return output;
}// replaceText()


// __________________________________________________________
// removeText
RAM_F.removeText = function(){
	// var removeThis = arguments[0];
	// var fromThis = arguments[1];
	// return fromThis.split( removeThis ).join("");
	return RAM_F.replaceText.apply( this, arguments.slice() );
}// removeText()


// __________________________________________________________
// hasText
RAM_F.hasText = function(){
	var findThis = arguments[0].toLowerCase();
	var inThis = arguments[1].toLowerCase();
	var index = inThis.indexOf( findThis );
	return (index > -1);		// true / false
}// hasText()


// __________________________________________________________
// splitString
RAM_F.splitString = function(){
	var splitThis = arguments[0].toLowerCase();
	var usingThis = arguments[1].toLowerCase();
	return splitThis.split( usingThis );
}// splitString()


// __________________________________________________________
// trimDecimal
RAM_F.trimDecimal = function( input_num, trimToThisLength ){
	var input_num = arguments[0];
	var trimToThisLength = arguments[1];
	// ABORT:   if bad parameters
	if( isNaN(input_num) )					return input_num;
	if( isNaN(trimToThisLength) )		return input_num;
	// Else:  do the thing
	var input_str = String(input_num);
	var decimalAt = input_str.indexOf('.');
	if( decimalAt > -1 ){
		// if:  has a decimal point
		var beforeDecimal = input_str.substr( 0, decimalAt );
		var afterDecimal = input_str.substr( decimalAt+1 );
		afterDecimal = afterDecimal.substr( 0, trimToThisLength );
		var new_str = beforeDecimal + '.' + afterDecimal;
		// return the trincated number
		var new_num = Number(new_str);
		return new_num;
	}// if:  has a decimal point
	
	// nothing needed to be done  =>  return the original number
	return input_num;
}// trimDecimal()


// __________________________________________________________
// removeArrayItem  (remove an element from an array via splice()
RAM_F.array = {}
RAM_F.array.removeValues = function(){
	// get parameters
	var arrayPath = arguments[0];
	var value = Number(arguments[1]);
	// get array
	var thisArray = getPathValue(arrayPath, "RAM");
	// if:  no array found,  then abort
	if( (thisArray instanceof Array) == false )		return false;
	// if:  invalid value,  then abort
	if( value === "" )		return false;
	// find all items matching this value and remove them
	for(var i in thisArray){
		// if found a match
		if( thisArray[ i ] === value ){
			// remove this from the array
			thisArray.splice( i, 1 );
		}// if found a match
	}// for everything in this array
	return true;		// successful attempt
}// removeValues()


RAM_F.array.remove = function(){
	// get parameters
	var arrayPath = arguments[0];
	var index = Number(arguments[1]);
	// get array
	var thisArray = getPathValue(arrayPath, "RAM");
	// if:  no array found,  then abort
	if( (thisArray instanceof Array) == false )		return null;
	// if:  invalid index,  then abort
	var indexIsNumber = !isNaN(index);
	if(indexIsNumber == false)		return null;
	// remove this element
	var removedItem = thisArray.splice( index, 1 );
	// announce success
	return removedItem[0];
}// removeArrayItem()
RAM_F.removeArrayItem = RAM_F.array.remove;																																
RAM_F.array.add = function( arrayPath, newItem, addAt ){
	// get parameters
	var arrayPath = arguments[0];	// required
	var newItem = arguments[1];		// optional  (missing = push an "undefined" value into array)
	var addAt = arguments[2];			// optional  (missing = append newItem to the end of the array)
	// sanity checks
	if( !arrayPath )		return false;
	// get array
	var thisArray = getPathValue(arrayPath, "RAM");
	// if:  no array found,  then abort
	if( (thisArray instanceof Array) == false )		return false;
	// add this element
	if(addAt === undefined){
		thisArray.push( newItem );
		addAt = thisArray.length;
	}else{
		thisArray.splice( addAt, 0, newItem );
	}
	// report the result
	return addAt;
}// array add()
RAM_F.array.shuffle = function( arrayPath ){
	// get parameters
	var arrayPath = arguments[0];	// required
	// sanity check
	if( !arrayPath )		return false;
	// get array
	var thisArray = getPathValue(arrayPath, "RAM");
	// sanity check
	if( ( thisArray instanceof Array ) === false )		return false;
	
	thisArray.sort( sortRand );
	function sortRand( a, b ){
		return Math.floor( Math.random() * 3) -1;		// randomly picks between:  -1, 0, 1
	}// sortFunc()
	return thisArray;
}// shuffle()



// __________________________________________________________
// makeObjectString
RAM_F.makeObjectString = function( objPath ){
	var objPath = arguments[0];
	if(!objPath)	return;
	// resolve [vars]  &  get the object specified by the string path
	var obj = evalPath( objPath, "RAM" );
	// create the output string
	var output = "";
	//output += "{";
	for(var nam in obj){
		if( obj[nam] instanceof Object )		continue;		// ignore objects & arrays
		output += nam;						// variable name
		output += ":";						// =
		output += obj[nam];		// value
		output += ",";						// (delimiter)
	}// for:  each item in the pokemon path
	// remove trailing delimiter
	output = output.substr( 0, output.length-1 );
	//output += "}";
	return output;
}// makeObjectString()







// __________________________________________________________
// setVars
#include "functions/readXml.as"
setRam = function()
{
	var newRam_str = arguments[0];
	var newRam_xml = new XML(newRam_str);
	var newRam = {};
	readXml( newRam_xml, newRam );
	_global.RAM = newRam.data;
}// setRam()


// __________________________________________________________
// getListFromObject
RAM_F.getListFromObject = function( objPath ){
	var objPath = arguments[0];
	if( !objPath )		return undefined;
	var objRef = evalPath( objPath, "RAM" );
	if( !objRef )			return undefined;
	var output = [];
	for(var nam in objRef){
		output.push( nam );
	}// for:  each item in the specified object
	output.reverse();
	return output;
}// getListFromObject()


// __________________________________________________________
RAM_F.spriteListAtTile = function( xTile, yTile ){
	var xTile = arguments[0];
	var yTile = arguments[1];
	var spriteList = SPRITE_GRID[xTile][yTile];
	if(spriteList  &&  spriteList.length > 0){
		return spriteList;
	}else{
		return undefined;
	}
}// spriteListAtTile()


// __________________________________________________________
// getKeyName
#include "functions/getKeyName.as"
RAM_F.getKeyName = getKeyName;